package nemosofts.notes.app.activity;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;

import androidx.activity.EdgeToEdge;
import androidx.activity.OnBackPressedCallback;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.appcompat.widget.Toolbar;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.nemosofts.AppCompatActivity;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;

import java.util.ArrayList;
import java.util.List;

import nemosofts.notes.app.R;
import nemosofts.notes.app.adapters.NoteAdapter;
import nemosofts.notes.app.item.Note;
import nemosofts.notes.app.utils.AsyncTaskExecutor;
import nemosofts.notes.app.utils.IfSupported;
import nemosofts.notes.app.utils.helper.DBHelper;
import nemosofts.notes.app.utils.helper.Helper;

public class DeleteActivity extends AppCompatActivity {

    public  static  final int REQUEST_CODE_ADD_NOTE = 1;
    public  static  final int REQUEST_CODE_UPDATE_NOTE = 2;
    private RecyclerView notesRecyclerView;
    private List<Note> noteList;
    private NoteAdapter noteAdapter;
    private DBHelper dbHelper;
    private final ActivityResultLauncher<Intent> restoreNoteLauncher =
            registerForActivityResult(new ActivityResultContracts.StartActivityForResult(), result -> {
                if (result.getResultCode() == RESULT_OK && result.getData() != null) {
                    getNotes(REQUEST_CODE_UPDATE_NOTE);
                }
            });

    private ProgressBar pb;
    private String errorMsg;
    private FrameLayout frameLayout;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        IfSupported.isRTL(this);
        IfSupported.isScreenshot(this);
        EdgeToEdge.enable(this);
        ViewCompat.setOnApplyWindowInsetsListener(findViewById(R.id.bg_page), (v, insets) -> {
            Insets systemBars = insets.getInsets(WindowInsetsCompat.Type.systemBars());
            v.setPadding(systemBars.left, systemBars.top, systemBars.right, systemBars.bottom);
            return insets;
        });

        Toolbar toolbar = findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        if (getSupportActionBar() != null) {
            getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            getSupportActionBar().setDisplayShowHomeEnabled(true);
        }
        toolbar.setNavigationOnClickListener(view -> finish());
        setTitle(R.string.recycle_bin);

        dbHelper = new DBHelper(this);

        frameLayout = findViewById(R.id.fl_empty);
        pb = findViewById(R.id.pb);

        notesRecyclerView = findViewById(R.id.deleteRecyclerView);
        notesRecyclerView.setLayoutManager(new StaggeredGridLayoutManager(2, StaggeredGridLayoutManager.VERTICAL));

        noteList = new ArrayList<>();
        noteAdapter = new NoteAdapter(this,  noteList, (note, position) -> {
            Intent intent = new Intent(getApplicationContext(), RestoreNoteActivity.class);
            intent.putExtra("isViewOrUpdate", true);
            intent.putExtra("note", note);
            restoreNoteLauncher.launch(intent);
        });
        notesRecyclerView.setAdapter(noteAdapter);
        getNotes(REQUEST_CODE_ADD_NOTE);

        OnBackPressedCallback callback = new OnBackPressedCallback(true) {
            @Override
            public void handleOnBackPressed() {
                finish();
            }
        };
        getOnBackPressedDispatcher().addCallback(this, callback);

        LinearLayout adView = findViewById(R.id.ll_adView);
        new Helper(this).showBannerAd(adView);
    }

    @Override
    public int setContentViewID() {
        return R.layout.activity_delete;
    }

    private void getNotes(final int resultCode){
        new AsyncTaskExecutor<String, String, String>() {

            final List<Note> notes = new ArrayList<>();

            @Override
            protected void onPreExecute() {
                super.onPreExecute();
                frameLayout.setVisibility(View.GONE);
                notesRecyclerView.setVisibility(View.GONE);
                pb.setVisibility(View.VISIBLE);
            }

            @Override
            protected String doInBackground(String strings) {
                try {
                    notes.addAll(dbHelper.getDeletedNotes());
                    return "1";
                } catch (Exception e) {
                    return "0";
                }
            }

            @SuppressLint("NotifyDataSetChanged")
            @Override
            protected void onPostExecute(String s) {
                if (isFinishing()){
                    return;
                }
                if (notes.isEmpty()){
                    errorMsg = "No Notes";
                    setEmpty(notes);
                    return;
                }
                if (!noteList.isEmpty()){
                    noteList.clear();
                }
                noteList.addAll(notes);
                noteAdapter.notifyDataSetChanged();
                if (!notes.isEmpty() && resultCode == REQUEST_CODE_UPDATE_NOTE){
                    notesRecyclerView.smoothScrollToPosition(0);
                }
                errorMsg = "add Data";
                setEmpty(notes);
            }
        }.execute();
    }

    private void setEmpty(List<Note> notes) {
        if (notes== null || !notes.isEmpty()) {
            notesRecyclerView.setVisibility(View.VISIBLE);
            pb.setVisibility(View.INVISIBLE);
            frameLayout.setVisibility(View.GONE);
            return;
        }
        notesRecyclerView.setVisibility(View.GONE);
        frameLayout.setVisibility(View.VISIBLE);
        pb.setVisibility(View.INVISIBLE);

        frameLayout.removeAllViews();
        LayoutInflater inflater = (LayoutInflater) getSystemService(Context.LAYOUT_INFLATER_SERVICE);

        @SuppressLint("InflateParams") View myView = inflater.inflate(R.layout.row_empty, null);

        TextView textView = myView.findViewById(R.id.tv_empty_msg);
        textView.setText(errorMsg);

        myView.findViewById(R.id.ll_empty_try).setOnClickListener(v -> {
            myView.findViewById(R.id.iv_empty).setVisibility(View.GONE);
            myView.findViewById(R.id.pb_empty).setVisibility(View.VISIBLE);
            new Handler().postDelayed(() -> {
                myView.findViewById(R.id.iv_empty).setVisibility(View.VISIBLE);
                myView.findViewById(R.id.pb_empty).setVisibility(View.GONE);
                getNotes(REQUEST_CODE_ADD_NOTE);
            }, 500);
        });
        frameLayout.addView(myView);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        if (menuItem.getItemId() == android.R.id.home) {
            finish();
        } else {
            return super.onOptionsItemSelected(menuItem);
        }
        return true;
    }
}